#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <io.h>

#define		__GNL_BUFF_SIZE__	4096

static	char	buff[__GNL_BUFF_SIZE__];
static	int		in_buf = 0;
static	int		start;


static int	read_from_file(int fd)
{
	in_buf = read(fd, buff, __GNL_BUFF_SIZE__);
	start = 0;
	return (in_buf);
}


static char		*add_to_line(char *line, int cur)
{
	char		*new_elem;
	int			old_len;
	
	if (!(new_elem = malloc((old_len = (line?strlen(line):0)) + cur + 1)))
    {
		printf("add_to_line : error malloc\n");
		return (0);
    }
	strcpy(new_elem, line?line:"");
	memcpy(new_elem + old_len, buff + start, cur);
	new_elem[old_len + cur] = 0;
	if (line)
		free(line);
	start += cur + 1;
	return (new_elem);
}


char		*get_next_line(int fd)
{
	int		cur;
	char	*line;
	
	for (line = 0, cur = 0; ; cur++)
    {
		if (start >= in_buf)
		{
			if (!read_from_file(fd))
				return (line);
			cur = 0;
		}
		if (buff[start + cur] == '\n')
		{
			line = add_to_line(line, cur);
			return (line);
		}
		if (start + cur == in_buf - 1)
			line = add_to_line(line, cur + 1);
    }
}
