#include <stdlib.h>
#include <string.h>
#include <stdio.h>


int			is_sep(char lettre, char *sep)
{
	int		i;

	for (i = 0; sep[i]; i++)
	{
		if (lettre == sep[i])
			return (1);
	}
	return (0);
}

int			count_word(char *sep, char *str)
{
	int		i;
	int		nb_word;

	i = 0;
	nb_word = 0;
	while (str[i])
	{
		while (str[i] && is_sep(str[i], sep))
			i++;
		if (str[i])
			nb_word++;
		while (str[i] && !is_sep(str[i], sep))
			i++;
	}
	return (nb_word);
}

char		*get_first_word(char *sep, char *str)
{
	int		i;
	int		k;
	char	*res;
  
	i = 0;
	while (str[i] && !is_sep(str[i], sep))
		i++;
	if (!(res = (char*)malloc((i + 1) * sizeof(char))))
	{
		fprintf(stderr, "get_first_word : error malloc\n");
		return (0);
	}
	res[i] = 0;
	for (k = 0; k < i; k++)
		res[k] = str[k];
	return (res);
}

char		**str_to_word_tab(char *sep, char *str)
{
	int		i, k;
	char	**tab;

	i = count_word(sep, str);
	if (!(tab = (char**)malloc((i + 1) * sizeof(char*))))
	{
		fprintf(stderr, "str_to_word_tab : error malloc\n");
		return (0);
	}
	tab[i] = 0;
	i = 0;
	k = 0;
	while (str[i])
	{
		while (str[i] && is_sep(str[i], sep))
			i++;
		if (str[i])
		{
			tab[k] = get_first_word(sep, str + i);
			k++;
		}
		while (str[i] && !is_sep(str[i], sep))
			i++;
	}
	return (tab);
}
