#include "bot.h"

void	traitement(char *str, t_bot *bot)
{
	int		len;
	char	buff[LITTLE_BUFF];
	char	**tab;
	char	*msg;

	if (str == NULL)
		return ;
	tab = str_to_word_tab(" :!", str);
	msg = strstr(str + 1, ":") + 1;

	if (str[0] == ':')
	{
		if (bot->server_name == NULL || strcmp(tab[0] + 1, bot->server_name))
		{
			if (bot->server_name)
				free(bot->server_name);
			bot->server_name = strdup(tab[0] + 1);
		}
	}

	if (!strcmp(tab[0], "PING"))
	{
		len = _snprintf(buff, LITTLE_BUFF, "PONG %s\r\n", tab[1]);
		tcp_send(buff, len, 0, bot->tcp);
		free_tab(tab);
		return ;
	}

	if (!strcmp(tab[2], "PRIVMSG"))
		received_message(tab[0], tab[1], tab[3], msg, bot);

    free_tab(tab);
}

void	start_bot(t_bot *bot)
{
	int		i;
	int		ret;
	char	buff[BIG_BUFF];
	char	**tab;

	while (42)
	{
		ret = tcp_receive(buff, BIG_BUFF, bot->tcp);
		if (ret == 0)
			continue;
		if (ret == LIBTCP_FAILED)
		{
			printf("connexion lost to ");
			set_color(1, 0, 0, 1);
			printf("%s\n", bot->server_addr);
			restore_default_color();
			break;
		}
		tab = str_to_word_tab("\r\n", buff);
		for (i = 0; tab[i]; i++)
		{
			if (tab[i][0] == 0)
				continue;
			traitement(tab[i], bot);
		}
		free_tab(tab);
	}
	reconnect(bot);
}
