#include "bot.h"

void	reconnect(t_bot *bot)
{
	int		ret;
	int		port;
	char	*server;
	char	**tab;

	while (42)
	{
		server = get_next_line_ex(bot->fd_servers);
		if (server == NULL)
		{
			set_color(1, 0, 0, 1);
			printf("unable to connect to any servers, retry\n\n");
			restore_default_color();
			fseek(bot->fd_servers, 0, SEEK_SET);
			continue;
		}
		trim(server, " \t\r");
		tab = str_to_word_tab(":", server);
		port = 6667;
		if (tab[1] != NULL)
			port = atoi(tab[1]);
		if (bot->server_addr)
			free(bot->server_addr);
		bot->server_addr = strdup(server);
		printf("connecting to %s...\n", server);
		ret = tcp_connect(tab[0], (short)port, bot->tcp);
		free_tab(tab);
		if (ret == LIBTCP_OK)
		{
			printf("connected to %s : ", server);
			set_color(0, 1, 0, 1);
			printf("ok\n");
			restore_default_color();
			free(server);
			break;
		}
		printf("unable to connect to ");
		set_color(1, 0, 0, 1);
		printf("%s\n", server);
		restore_default_color();
		free(server);
	}
}
