#include "bot.h"

void	load_conf(t_bot *bot)
{
	int		i;
	char	*str;
	char	*conf_file;
	char	**tab;
	FILE	*fd;

	conf_file = get_good_file(bot->av[0], "conf.txt");
	fd = fopen(conf_file, "rb");
	if (fd == NULL)
	{
		printf("a configuration is needed, generating a default one\n");
		fd = fopen(conf_file, "wb");
		fprintf(fd, "name = noname\r\n");
		fprintf(fd, "room = #one_room,#another_one\r\n");
		fclose(fd);
		exit(1);
	}
	free(conf_file);
	while ((str = get_next_line_ex(fd)))
	{
		tab = str_to_word_tab("\t,=", str);
		for (i = 0; tab[i]; i++)
			trim(tab[i], " \t\r");
		if (!strcmp(tab[0], "name"))
		{
			bot->bot_name = strdup(tab[1]);
			free_tab(tab);
			free(str);
			continue;
		}
		if (!strcmp(tab[0], "room"))
			bot->room_names = &tab[1];
		free(str);
	}
}
