#ifndef	__LIBTCP_H__
#define	__LIBTCP_H__

#include <winsock2.h>


#define	LIBTCP_OK			0
#define	LIBTCP_FAILED		-1


typedef struct			s_tcp
{
	int					socket;
	struct	WSAData		wsaData;
	struct sockaddr_in	my_addr;
	struct sockaddr_in	remote_addr;
	int					sin_size;
	long				timeout;

}						t_tcp;


t_tcp	*tcp_new();
void	tcp_delete(t_tcp *tcp);

int	tcp_settimeout(long milliseconds, t_tcp *tcp);
int	tcp_create(unsigned short socketport, char *socketaddress, t_tcp *tcp);
int	tcp_connect(char *hostaddress, unsigned short port, t_tcp *tcp);
int	tcp_listen(int backlog, t_tcp *tcp);
int	tcp_accept(void *newsocket, long timeout_ms, t_tcp *tcp);
int	tcp_send(const char *buff, int bufflen, int flags, t_tcp *tcp);
int	tcp_receive(char *buff, int bufflen, t_tcp *tcp);
int	tcp_close(t_tcp *tcp);


#endif
