#include <process.h>
#include "bot.h"

#define TIMEOUT		20

int		id_bot(t_bot *bot)
{
	int		i;
	int		ret;
	int		len;
	char	buff[BIG_BUFF];
	char	**tab;
	char	**big_tab;

	len = _snprintf(buff, BIG_BUFF, "USER UNIX %s BeOS truc: truc\r\n", bot->bot_name);
	tcp_send(buff, len, 0, bot->tcp);
	len = _snprintf(buff, BIG_BUFF, "NICK %s\r\n", bot->bot_name);
	tcp_send(buff, len, 0, bot->tcp);
	while (42)
	{
		ret = tcp_receive(buff, BIG_BUFF, bot->tcp);
		if (ret == 0)
			continue;
		if (ret == LIBTCP_FAILED)
		{
			printf("connexion lost to ");
			set_color(1, 0, 0, 1);
			printf("%s\n", bot->server_addr);
			restore_default_color();
			reconnect(bot);
			continue;
		}

		big_tab = str_to_word_tab("\n", buff);
		
		for (i = 0; big_tab[i]; i++)
		{
			trim(big_tab[i], "\r");

			if (big_tab[i][0] == 0)
				continue;

			if (!strncmp(big_tab[i], "ERROR :", 7))
			{
				set_color(1, 1, 1, 1);
				printf(big_tab[i] + 7);
				restore_default_color();
				free_tab(big_tab);
				return (0);
			}

			tab = str_to_word_tab(" ", big_tab[i]);

			if (tab[1] != NULL)
			{
				if (!strcmp(tab[1], "001"))
				{
					if (bot->server_name)
						free(bot->server_name);
					bot->server_name = strdup(tab[0] + 1);
				}
				if (!strcmp(tab[1], "376"))
				{
					printf("communication with server : ");
					set_color(0, 1, 0, 1);
					printf("ok\n");
					set_color(1, 1, 1, 1);
					printf("by motd\n");
					restore_default_color();
					free_tab(tab);
					free_tab(big_tab);
					return (1);
				}
				if (!strcmp(tab[1], "433") || !strcmp(tab[1], "432"))
				{
					set_color(1, 0, 1, 1);
					printf("nickname %s already in use, exiting :(\n", bot->bot_name);
					restore_default_color();
					system("pause");
					exit(1);
				}
			}

			if (tab[0] != NULL)
			{
				if (!strcmp(tab[0], "PING"))
				{
					len = _snprintf(buff, BIG_BUFF, "PONG %s\r\n", tab[1]);
					tcp_send(buff, len, 0, bot->tcp);
					printf("communication with server : ");
					set_color(0, 1, 0, 1);
					printf("ok\n");
					set_color(1, 1, 1, 1);
					printf("by ping\n");
					restore_default_color();
					free_tab(tab);
					free_tab(big_tab);
					return (1);
				}
			}

			free_tab(tab);
		}
		free_tab(big_tab);
	}
	return (1);
}
