#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <io.h>

#define	_GNL_BUFF_SIZE_	1024


static	char	buff[_GNL_BUFF_SIZE_];
static	int		in_buf = 0;
static	int		start;


static int	read_from_file(int fd)
{
	in_buf = read(fd, buff, _GNL_BUFF_SIZE_);
	start = 0;
	return (in_buf);
}


static char		*add_to_line(char *line, int cur)
{
	char		*new_elem;
	int			old_len;
	
	if (!(new_elem = malloc((old_len = (line?(int)strlen(line):0)) + cur + 1)))
    {
		fprintf(stderr, "unable to perform malloc\n");
		return (0);
    }
	strcpy(new_elem, line?line:"");
	memcpy(new_elem + old_len, buff + start, cur);
	new_elem[old_len + cur] = 0;
	if (line)
		free(line);
	start += cur + 1;
	return (new_elem);
}


char		*get_next_line(int fd)
{
	int		cur;
	char	*line;
	
	for (line = 0, cur = 0; ; cur++)
    {
		if (start >= in_buf)
		{
			if (!read_from_file(fd))
				return (line);
			cur = 0;
		}
		if (buff[start + cur] == '\n')
		{
			line = add_to_line(line, cur);
			return (line);
		}
		if (start + cur == in_buf - 1)
			line = add_to_line(line, cur + 1);
    }
}
