#include "bot.h"

void	connect_bot(t_bot *bot)
{
	int		port;
	int		ret;
	char	*file;
	char	*server;
	char	**tab;

	file = get_good_file(bot->av[0], "server_list.txt");
	bot->fd_servers = fopen(file, "rb");
	free(file);
	while (42)
	{
		server = get_next_line_ex(bot->fd_servers);
		if (server == NULL)
		{
			set_color(1, 0, 0, 1);
			printf("unable to connect to any servers, retry\n");
			restore_default_color();
			fseek(bot->fd_servers, 0, SEEK_SET);
			continue;
		}
		trim(server, " \t\r");
		tab = str_to_word_tab(":", server);
		port = 6667;
		if (tab[1] != NULL)
			port = atoi(tab[1]);
		if (bot->server_addr)
			free(bot->server_addr);
		bot->server_addr = strdup(server);
		printf("connecting to %s...\n", bot->server_addr);
		ret = tcp_connect(tab[0], (short)port, bot->tcp);
		free_tab(tab);
		if (ret == LIBTCP_OK)
		{
			printf("connected to %s : ", server);
			set_color(0, 1, 0, 1);
			printf("ok\n");
			restore_default_color();
			free(server);
			break;
		}
		printf("unable to connect to ");
		set_color(1, 0, 0, 1);
		printf("%s\n\n", server);
		restore_default_color();
		free(server);
	}
}
