#ifndef _BOT_H_
#define _BOT_H_


#include <stdio.h>
#include "libtcp.h"


#define STACK_SIZE		64
#define LITTLE_BUFF		512
#define BIG_BUFF		4096


typedef	struct	s_bot
{
	char		**av;
	char		*bot_name;
	char		*server_name;
	char		*server_addr;
	int			room_number;
	char		**room_names;
	t_tcp		*tcp;
	FILE		*fd_servers;

}				t_bot;


void	connect_bot(t_bot *bot);
char	*get_good_file(char *av_zero, char *f);
char	*get_next_line(int fd);
char	*get_next_line_ex(FILE *fd);
void	init_bot(char **av, t_bot *bot);
char	**str_to_word_tab(char *sep, char *str);
char	*trim(char *str, char *inib);
int		free_tab(char **tab);
void	load_conf(t_bot *bot);
int		id_bot(t_bot *bot);
void	reconnect(t_bot *bot);
void	join_rooms(t_bot *bot);
void	start_bot(t_bot *bot);
void	received_message(char *from, char *id, char *room, char *msg, t_bot *bot);
void	set_color(int r, int g, int b, int intensity);
void	restore_default_color();


#endif
