#include <stdio.h>
#include <math.h>
#include "fifon.h"

#define	SEUIL	10

#define	R		0
#define	G		1
#define	B		2

typedef	unsigned int	uint;

void		filter(t_bmp *bmp, t_opt *opt)
{
	int		line;
	int		col;
	int		nb_line;
	int		nb_col;
	uint	val[3];

	nb_line = bmp->height - 1;
	nb_col = bmp->width - 1;
	for (line = 1; line < nb_line; line++)
	{
		for (col = 1; col < nb_col; col++)
		{
			val[R] = 0;
			val[G] = 0;
			val[B] = 0;

			val[R] += bmp->data[line][col - 1].r;
			val[G] += bmp->data[line][col - 1].g;
			val[B] += bmp->data[line][col - 1].b;

			val[R] += bmp->data[line][col + 1].r;
			val[G] += bmp->data[line][col + 1].g;
			val[B] += bmp->data[line][col + 1].b;

			val[R] += bmp->data[line - 1][col].r;
			val[G] += bmp->data[line - 1][col].g;
			val[B] += bmp->data[line - 1][col].b;

			val[R] += bmp->data[line + 1][col].r;
			val[G] += bmp->data[line + 1][col].g;
			val[B] += bmp->data[line + 1][col].b;

			val[R] = (val[R] / 4);
			val[G] = (val[G] / 4);
			val[B] = (val[B] / 4);

			if (abs(bmp->data[line][col].r - val[R]) < SEUIL || abs(bmp->data[line][col].g - val[G]) < SEUIL || abs(bmp->data[line][col].b - val[B]) < SEUIL)
			{
				bmp->data[line][col].r = (bmp->data[line][col].r + val[R]) / 2;
				bmp->data[line][col].g = (bmp->data[line][col].g + val[G]) / 2;
				bmp->data[line][col].b = (bmp->data[line][col].b + val[B]) / 2;
			}
		}
	}
}
